/* This file provides the Stata labels for variables in the BRD */


lab var NameCorp "Company name"
lab var AfterEmerging "After emerging events"
lab var Assets1Before "Assets, one year before case filing"
lab var Assets2Before "Assets, two years before case filing"
lab var Assets3Before "Assets, three years before case filing"
lab var AssetsBefore "Assets, last year reported before case filing"
lab var AssetsCurrDollar "Assets, current dollars, last year reported before case filing"
lab var AssetsEmerging "Assets after emerging"
lab var AssetsPetCurrDollar "Assets as shown on Exhibit A, in current dollars"
lab var AssetsPetition "Assets as shown on Exhibit A"
lab var CaseNum "Case number for the lead case"
lab var CaseNumTransfer "Case number for the lead case"
lab var CeoFiling "Name of chief executive officer at case filing"
lab var Chapter "Chapter of bankruptcy code under which case was filed"
lab var CikBefore "Central Index Key number of filing company (EDGAR)"
lab var CikEmerging "Central Index Key number of emerging company (EDGAR)"
lab var CityDisposed "Court city at case disposition"
lab var CityFiled "City in which the case was filed"
lab var CityRefile "Court city of refiling"
lab var ClaimsSecDiscloState "Total secured claims"
lab var ClaimsUnsec "Total unsecured, non-priority claims"
lab var CommCred "Official creditors committee appointed"
lab var CommEquity "Official equity committee appointed"
lab var CommEquityName "Official equity committee name"
lab var CommRetirees "Official retiree committee appointed"
lab var CommRetireesName "Official retiree committee name"
lab var CommRetireesRequest "Official retireee committee requested"
lab var CommonName "Common name of the corporate group"
lab var CPIndexAtConf "Consumer price index for confirmation month"
lab var CPIndexAtFiling "Consumer price index for case filing month"
lab var Cusip6 "Committee on Uniform Securities Identification Procedures company identifier"
lab var Cusip9 "Committee on Uniform Securities Identification Procedures security identifier"
lab var Date10k1Before "10-K coverage ending date in first year before case filing"
lab var Date10k2Before "10-K coverage ending date in second year before case filing"
lab var Date10k3Before "10-K coverage ending date in third year before case filing"
lab var Date10kBefore "Last 10-K coverage ending date before case filing"
lab var Date10kBeforeLink "Link to last 10-K  with coverage ending before case filing"
lab var Date10kDuring "First 10-K coverage ending date after case filing"
lab var Date10kDuringLink "Link to first 10-K with coverage ending after case filing"
lab var Date10kEmerging "Ending date of first 10-K showing post-reorganization assets and liabilities"
lab var Date10kEmergLink "Link to first 10-K showing post-reorganization assets and liabilities"
lab var Date10kSalesEmerge "Ending date of first 10-K showing one year of post-reorganization sales"
lab var Date363Sale "Date of pre-confirmation court order authorizing sale of substantially all assets"
lab var DateCeoBegin "Date chief executive officer at case filing assumed office"
lab var DateCeoEnd "Date chief executive officer at case filing left office"
lab var DateConfirmed "Date judge signed plan confirmation order"
lab var DateConvDismiss "Date judge signed order dismissing case or converting case to chapter 7"
lab var DateDiscloState "Date filed of disclosure statement for confirmed reorganization plan"
lab var DateDisposed "Date of first order confirming plan or dismissing or converting case"
lab var DateEffective "Date the confirmed reorganization plan became effective "
lab var DateEmerging "Date of earlier of order approving 363 sale or plan confirmation"
lab var DateFeeRev "Date of first order to appoint a fee reviewer"
lab var DateFiled "Date of bankruptcy case filing"
lab var DateRefile "Date on which the emerging company refiled bankruptcy"
lab var DateTransferred "Date of order tranferring case to a different court city"
lab var DaysDocsAfter "Number of days from first documents on Pacer to case disposition"
lab var DaysFiledTo363 "Number of days from case filing to order approving 363 sale"
lab var DaysEmergeToRefile "Number of days from Emergence to refiling"
lab var DaysIn "Number of days from case filing to case disposition"
lab var DENYOther "Court city at filing, categorized as Delaware, Manhattan division, or other"
lab var DipAtty "Debtor-in-possesions lead bankruptcy attorney at case filing"
lab var Disposition "Disposition of the Chapter 11 case"
lab var DistFiled "Federal court district in which case was filed"
lab var DistribComments "Comments regarding claims and distributions"
lab var DistribEquity "Total distributions to equity in dollars"
lab var DistribSecDiscloState "Total distributions to prepetition secured creditors in millions of dollars"
lab var DistribUnsec "Total distributions to unsecured non-priority creditors"
lab var DistribUnsecPct "Ratio of distributions to claims for unsecured non-priority creditors"
lab var DktNumConf "Docket number of the plan confirmation order"
lab var DktOnPacer "Docket available on Pacer"
lab var DocsOnPacer "Documents available on Pacer"
lab var EbitBefore "Earnings before interest and taxes, for last year ending before case filing"
lab var EbitdaBefore "Earnings before interest, taxes, depreciation for last year ending before case filing"
lab var EbitdaEmerging "Earnings before interest, taxes, depreciation for first year ending after disposition"
lab var EbitEmerging "Earnings before interest and taxes, for first year ending after disposition"
lab var Emerge "Company emerged from bankruptcy by 363 sale or plan confirmation"
lab var Emerg10k "Emerged company filed form 10-K within three years after confirmation"
lab var EmplBefore "Number of employees of filing company"
lab var EmplEmerging "Number of employees of emerged company"
lab var EmplUnionBefore "Number of union employees of filing company"
lab var EmplUnionEmerging "Number of union employees of emerged company"
lab var Examiner "Court ordered appointment of an examiner "
lab var ExaminerName "Name of examiner appointed"
lab var ExaminerRequest "Some party requested examiner appointment"
lab var FeeReviewer "Fee examiner, auditor, or committee appointed"
lab var FreshStartAccounting "Emerging company adopted fresh start accounting"
lab var GdpDisp "Gross domestic product at case disposition"
lab var GdpFiling "Gross domestic product at case filing"
lab var GdpRefiling "Gross domestic product at refiling"
lab var GdpYear1AftDisp "Gross domestic product one year after case disposition"
lab var GdpYear1BefFile "Gross domestic product one year before case filing"
lab var GdpYear2AftDisp "Gross domestic product two years after case disposition"
lab var GdpYear2BefFile "Gross domestic product two years before case filing"
lab var GvkeyBefore "Global Company Key number for filing company"
lab var GvkeyEmerging "Global Company Key number for emerging company"
lab var HeadCAtFiling "Companys headquarters city at case filing"
lab var HeadCourtCity "Bankruptcy court for companys headquarters city at case filing"
lab var HeadCourtCityToDE "Distance from companys headquarters city to Wilmington DE, in miles"
lab var HeadStAtFiling "Companys headquarters state at case filing"
lab var HqToForum "Distance from companys headquarters city to court city of filing"
lab var HqToHqCtCity "Distance from companys headquarters city to local court city"
lab var IncomeBEBefore "Income before extraordinary expenses for last year ending before case filing"
lab var IncomeBEEmerging "Income before extraordinary expenses for first year ending after case disposition"
lab var IncPublic "10-K filers jurisdiction of incorporation"
lab var JudgeDisposition "Name of judge who signed the order to confirm, dismiss or convert"
lab var JudgeFiling "Name of first judge assigned to the case"
lab var Liab1Before "Liabilities, one year before case filing"
lab var Liab2Before "Liabilities, two years before case filing"
lab var Liab3Before "Liabilities, three years before case filing"
lab var LiabBefore "Liabilities, last year reported before case filing"
lab var LiabCurrDollar "liabilities, current dollars, last year reported before case filing"
lab var LiabEmerging "Liabilities after emerging"
lab var LiabPetCurrDollar "Liabilities as shown on Exhibit A, in current dollars"
lab var LiabPetition "Liabilities as shown on Exhibit A"
lab var Multiple363Sales "Business was sold in several 363 sales"
lab var NameEmerging "Name of emerging company"
lab var NetIncomeBefore "Net income for last year ending before case filing"
lab var NetIncomeEmerging "Net income for first year ending after case disposition"
lab var NumberFiling "Number of group entities filing case"
lab var Prepackaged "Status of reorganization plan at case filing"
lab var PrimaryKey "Unique BRD identification number for this case"
lab var Prime1YearAftDisp "Prime interest rate one year after case disposition"
lab var Prime1YearBefFile "Prime interest rate one year before case filing"
lab var Prime2YearAftDisp "Prime interest rate two years after case disposition"
lab var Prime2YearBefFile "Prime interest rate two years before case filing"
lab var PrimeDisp "Prime interest rate at case disposition"
lab var PrimeFiling "Prime interest rate at case filing"
lab var PrimeRefiling "Prime interest rate at refiling"
lab var ProfFees10k "Professional fees and expenses reported on form 10-K"
lab var ProfFees10kNotes "Reason professional fees and expenses are not available"
lab var Refile "Company emerged from bankruptcy and refiled"
lab var Refile5 "Company emerged from bankruptcy and refiled within five year of confirmation"
lab var RelatedFilings "Bankruptcy cases related to this case but not consolidated"
lab var Sale363 "Company sold substantially all assets before plan confirmation"
lab var SaleIntended "Company intended at time of case filing to sell its business"
lab var Sales1Before "Sales, one year before case filing"
lab var Sales2Before "Sales, two years before case filing"
lab var Sales3Before "Sales, three years before case filing"
lab var SalesBefore "Sales, last year reported before case filing"
lab var SalesCurrDollar "Sales, in current dollars, last year reported before case filing"
lab var SalesEmerging "Sales in first full year after emergence"
lab var Shop "Case filed in a court other than the court for the companys headquarters"
lab var SICDescription "SIC Code description"
lab var SICDivision "SIC division"
lab var SICIndustryGroup "SIC industry group"
lab var SICMajGroup "SIC Code Major Group"
lab var SICPrimary "Primary Standard Industrial Classification (SIC) Code"
lab var TortCause "Tort debt caused the bankruptcy filing"
lab var TransCity "District, city and state to which case was transferred"
lab var Transferred "Case was transferred to a different court city"
lab var Trustee "Chapter 11 trustee was appointed prior to disposition"
lab var TrusteeFor "Entities for which Chapter 11 trustee was appointed"
lab var TrusteeName "Name of the Chapter 11 trusteee"
lab var TrusteeRequest "Name of the party requesting Chapter 11 trustee appointment"
lab var Voluntary "Case filed voluntarily"
lab var YearDisposed "Case disposition year"
lab var YearFiled "Case filing year"
lab var YearConfirmed "Case confirmation year"
lab var YearsEmergeToRefile "Number of years from confirmation to refiling"
